/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.util;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class RcsTrace {
    private static final String TRACE_MASKT = "XRCSDBGT";
    private static final String TRACE_MASKF = "XRCSDBGF";
    private static final String TRACE_MASKD = "XRCSDBGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-CallHome");
    private static final MicrocodeLogAttributes ERROR_LOG = MicrocodeLogAttributes.ERROR_LOG;
    private static final MicrocodeLogAttributes INFO_LOG = MicrocodeLogAttributes.INFO_LOG;
    private static final MicrocodeLogAttributes INFO_ERROR_LOG = new MicrocodeLogAttributes(false, false, true, true, false, false, false, 0);
    private static TimedStringSet traceBuffer = new TimedStringSet();

    private RcsTrace() {
    }

    public static synchronized void ttrace(String s) {
        Trace.trace(TRACE_MASKT, s);
        traceBuffer.add("T " + s);
    }

    public static synchronized void ftrace(String s) {
        Trace.trace(TRACE_MASKF, s);
        traceBuffer.add("F " + s);
    }

    public static synchronized void dtrace(String s) {
        Trace.trace(TRACE_MASKD, s);
        traceBuffer.add("D " + s);
    }

    public static synchronized void log(MicrocodeLogAttributes logType, String s) {
        RcsTrace.ttrace("<-> log( " + s + " )");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        ps.println("Description: " + s);
        FrameworkLog log = new FrameworkLog(classLogInfo, 2304);
        log.add(bs.toString());
        log.add(traceBuffer.toString());
        log.log(logType);
    }

    public static synchronized void log(MicrocodeLogAttributes logType, Throwable t) {
        RcsTrace.ttrace("<-> log( " + t + " )");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        ps.println("Throwable: " + t);
        ps.println("StackTrace: ");
        t.printStackTrace(ps);
        FrameworkLog log = new FrameworkLog(classLogInfo, 2304);
        log.add(bs.toString());
        log.add(traceBuffer.toString());
        log.log(logType);
    }

    public static synchronized void log(MicrocodeLogAttributes logType, String s, Throwable t) {
        RcsTrace.ttrace("<-> log( " + s + ", " + t + " )");
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bs);
        ps.println("Description: " + s);
        ps.println("Throwable: " + t);
        ps.println("StackTrace: ");
        t.printStackTrace(ps);
        FrameworkLog log = new FrameworkLog(classLogInfo, 2304);
        log.add(bs.toString());
        log.add(traceBuffer.toString());
        log.log(logType);
    }

    public static synchronized void logInfo(String s) {
        RcsTrace.log(INFO_LOG, s);
    }

    public static synchronized void logInfo(Throwable t) {
        RcsTrace.log(INFO_LOG, t);
    }

    public static synchronized void logInfo(String s, Throwable t) {
        RcsTrace.log(INFO_LOG, s, t);
    }

    public static synchronized void logInfoError(String s) {
        RcsTrace.log(INFO_ERROR_LOG, s);
    }

    public static synchronized void logInfoError(Throwable t) {
        RcsTrace.log(INFO_ERROR_LOG, t);
    }

    public static synchronized void logInfoError(String s, Throwable t) {
        RcsTrace.log(INFO_ERROR_LOG, s, t);
    }

    public static synchronized void logError(String s) {
        RcsTrace.log(ERROR_LOG, s);
    }

    public static synchronized void logError(Throwable t) {
        RcsTrace.log(ERROR_LOG, t);
    }

    public static synchronized void logError(String s, Throwable t) {
        RcsTrace.log(ERROR_LOG, s, t);
    }

    public static synchronized void logSystemEvent(LocalizableText text) {
        RcsTrace.logSystemEvent(text, "RCS-CallHome");
    }

    public static synchronized void logSystemEvent(LocalizableText text, String id) {
        new SystemEventLog(text, id).log();
    }

    public static class TimedStringSet {
        private static final long DEFAULT_TIME_SIZE = 3600000L;
        private static final String CONCAT_DELIM = "\n                        | ";
        private long maxSize;
        private SortedMap container = new TreeMap();

        public TimedStringSet() {
            this(3600000L);
        }

        public TimedStringSet(long msec) {
            long ts = System.currentTimeMillis();
            this.maxSize = msec > ts ? ts : msec;
        }

        public boolean add(Object o) throws UnsupportedOperationException, ClassCastException, NullPointerException, IllegalArgumentException {
            long ts = System.currentTimeMillis();
            Long tsObj = new Long(ts);
            String oStr = (String)this.container.get(tsObj);
            String nStr = oStr == null ? o.toString() : oStr + CONCAT_DELIM + o;
            this.container.put(tsObj, nStr);
            ts -= this.maxSize;
            try {
                Long keyObj;
                long key;
                while (!this.container.isEmpty() && (key = (keyObj = (Long)this.container.firstKey()).longValue()) < ts) {
                    this.container.remove(keyObj);
                }
            }
            catch (Exception e) {
                RcsTrace.ttrace("TimeStringSet.add() Exception: " + e);
            }
            return true;
        }

        public String toString() {
            String s = "";
            SimpleDateFormat myDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                Iterator i = this.container.keySet().iterator();
                while (i.hasNext()) {
                    Long key = (Long)i.next();
                    s = s + myDate.format(new Date(key)) + " | " + this.container.get(key) + "\n";
                }
            }
            catch (Exception e) {
                RcsTrace.ttrace("TimeStringSet.toString() Exception: " + e);
            }
            return s;
        }
    }
}

